<?php
// ================= تنظیمات امنیتی =================
$ADMIN_PASSWORD = "123456"; // ⚠️ حتماً این را تغییر دهید!
session_start();

if (!isset($_SESSION['admin_logged_in'])) {
    if ($_POST['password'] === $ADMIN_PASSWORD) {
        $_SESSION['admin_logged_in'] = true;
    } else {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $error = "رمز عبور اشتباه است!";
        }
        echo '<form method="post" style="text-align:center; margin-top:50px;">
            <h2>🔐 ورود به پنل مدیریت</h2>
            <input type="password" name="password" placeholder="رمز عبور" required style="padding:8px; width:200px; margin:10px;">
            <br><input type="submit" value="ورود" style="padding:8px; background:#007BFF; color:white; border:none; cursor:pointer;">
            ' . ($error ?? '') . '
        </form>';
        exit;
    }
}

// ================= دیتابیس =================
$dbFile = __DIR__."/buttons.db";
$db = new PDO("sqlite:$dbFile");
$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// ================= بارگذاری تنظیمات فعلی =================
function loadSettings($db) {
    $stmt = $db->prepare("SELECT key, value FROM settings");
    $stmt->execute();
    $settings = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $settings[$row['key']] = $row['value'];
    }
    return $settings;
}

$settings = loadSettings($db);

// ================= ذخیره تنظیمات =================
if ($_POST['action'] === 'save_settings') {
    foreach ($_POST as $key => $value) {
        if (strpos($key, 'setting_') === 0) {
            $realKey = substr($key, 8);
            $stmt = $db->prepare("INSERT OR REPLACE INTO settings (key, value) VALUES (:key, :value)");
            $stmt->execute([':key' => $realKey, ':value' => trim($value)]);
        }
    }
    $success = "✅ تنظیمات با موفقیت ذخیره شد.";    $settings = loadSettings($db); // بروزرسانی
}

// ================= آمار ربات =================
$stmt = $db->prepare("SELECT COUNT(*) FROM users");
$stmt->execute();
$totalUsers = $stmt->fetchColumn();

$stmt = $db->prepare("SELECT COUNT(*) FROM users WHERE first_seen > :time");
$stmt->execute([':time' => time() - 86400]);
$active24h = $stmt->fetchColumn();

// ================= مدیریت زبان‌ها =================
$langs = ['fa', 'en']; // شما می‌توانید اینجا زبان‌های دیگر را اضافه کنید
$langData = [
    'fa' => ['name' => 'فارسی', 'flag' => '🇮🇷'],
    'en' => ['name' => 'English', 'flag' => '🇺🇸'],
    // اضافه کردن زبان‌های دیگر به همین صورت
];

if ($_POST['action'] === 'add_lang') {
    $newLang = trim($_POST['new_lang_code']);
    $newLangName = trim($_POST['new_lang_name']);
    $newFlag = trim($_POST['new_flag']);

    if (!empty($newLang) && !empty($newLangName) && !empty($newFlag)) {
        $langs[] = $newLang;
        $langData[$newLang] = ['name' => $newLangName, 'flag' => $newFlag];
        
        // افزودن تنظیمات پیش‌فرض برای زبان جدید
        $defaultSettings = [
            "tutorial_text_$newLang" => "محتوای آموزش برای $newLang",
            "tutorial_link_$newLang" => "https://t.me/AiPramit",
            "prompt_text_$newLang" => "محتوای کانال پرامپت برای $newLang",
            "prompt_link_$newLang" => "https://t.me/AiPramit",
            "support_text_$newLang" => "محتوای پشتیبانی برای $newLang",
            "support_link_$newLang" => "https://t.me/AiPramit_Support"
        ];
        
        foreach ($defaultSettings as $key => $value) {
            $stmt = $db->prepare("INSERT OR IGNORE INTO settings (key, value) VALUES (:key, :value)");
            $stmt->execute([':key' => $key, ':value' => $value]);
        }
        
        $success = "✅ زبان $newLang با موفقیت اضافه شد.";
        $settings = loadSettings($db);
    } else {
        $error = "⚠️ تمام فیلدها الزامی هستند.";
    }
}
if ($_POST['action'] === 'delete_lang') {
    $delLang = trim($_POST['delete_lang']);
    if (in_array($delLang, $langs) && $delLang !== 'fa' && $delLang !== 'en') { // جلوگیری از حذف زبان‌های پیش‌فرض
        // حذف تنظیمات مربوط به این زبان
        $stmt = $db->prepare("DELETE FROM settings WHERE key LIKE :pattern");
        $stmt->execute([':pattern' => "$delLang%"]);
        
        $success = "✅ زبان $delLang با موفقیت حذف شد.";
        $settings = loadSettings($db);
    } else {
        $error = "⚠️ نمی‌توانید این زبان را حذف کنید.";
    }
}

?>

<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <title>📊 پنل مدیریت ربات AI PRAMIT</title>
    <style>
        body { font-family: Tahoma, sans-serif; direction: rtl; padding: 20px; background: #f5f5f5; }
        .container { max-width: 900px; margin: 0 auto; background: white; padding: 20px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
        h1, h2 { color: #333; }
        .section { margin: 20px 0; padding: 15px; border: 1px solid #ddd; border-radius: 5px; }
        input[type="text"], input[type="url"], textarea { width: 100%; padding: 8px; margin: 5px 0; }
        button { padding: 8px 15px; background: #007BFF; color: white; border: none; cursor: pointer; }
        button:hover { background: #0056b3; }
        .stat-box { display: flex; justify-content: space-around; flex-wrap: wrap; gap: 10px; }
        .stat-item { background: #e9f7fe; padding: 10px; border-radius: 5px; text-align: center; min-width: 150px; }
        .lang-list { display: flex; flex-wrap: wrap; gap: 10px; }
        .lang-item { padding: 10px; background: #eee; border: 1px solid #ccc; border-radius: 5px; }
        .logout { float: left; background: #dc3545; }
        .logout:hover { background: #c82333; }
    </style>
</head>
<body>
    <div class="container">
        <h1>📊 پنل مدیریت ربات AI PRAMIT</h1>
        <a href="?logout=1"><button class="logout">خروج</button></a>
        
        <?php if (isset($success)) echo "<div style='color:green;'>$success</div>"; ?>
        <?php if (isset($error)) echo "<div style='color:red;'>$error</div>"; ?>

        <!-- آمار -->
        <div class="section">
            <h2>📈 آمار ربات</h2>
            <div class="stat-box">                <div class="stat-item">کل کاربران: <strong><?= number_format($totalUsers) ?></strong></div>
                <div class="stat-item">فعال در 24 ساعت: <strong><?= number_format($active24h) ?></strong></div>
            </div>
        </div>

        <!-- تنظیمات محتوا -->
        <div class="section">
            <h2>📝 تنظیمات محتوای دکمه‌ها</h2>
            <form method="post">
                <input type="hidden" name="action" value="save_settings">
                
                <?php foreach ($langs as $lang): ?>
                    <h3><?= $langData[$lang]['flag'] ?> <?= $langData[$lang]['name'] ?></h3>
                    
                    <label>متن آموزش:</label>
                    <textarea name="setting_tutorial_text_<?= $lang ?>" rows="3"><?= htmlspecialchars($settings["tutorial_text_$lang"] ?? "") ?></textarea>
                    
                    <label>لینک آموزش:</label>
                    <input type="url" name="setting_tutorial_link_<?= $lang ?>" value="<?= htmlspecialchars($settings["tutorial_link_$lang"] ?? "") ?>">
                    
                    <label>متن کانال پرامپت:</label>
                    <textarea name="setting_prompt_text_<?= $lang ?>" rows="3"><?= htmlspecialchars($settings["prompt_text_$lang"] ?? "") ?></textarea>
                    
                    <label>لینک کانال پرامپت:</label>
                    <input type="url" name="setting_prompt_link_<?= $lang ?>" value="<?= htmlspecialchars($settings["prompt_link_$lang"] ?? "") ?>">
                    
                    <label>متن پشتیبانی:</label>
                    <textarea name="setting_support_text_<?= $lang ?>" rows="3"><?= htmlspecialchars($settings["support_text_$lang"] ?? "") ?></textarea>
                    
                    <label>لینک پشتیبانی:</label>
                    <input type="url" name="setting_support_link_<?= $lang ?>" value="<?= htmlspecialchars($settings["support_link_$lang"] ?? "") ?>">
                    <hr>
                <?php endforeach; ?>
                
                <button type="submit">💾 ذخیره تنظیمات</button>
            </form>
        </div>

        <!-- مدیریت زبان‌ها -->
        <div class="section">
            <h2>🌐 مدیریت زبان‌ها</h2>
            
            <form method="post">
                <input type="hidden" name="action" value="add_lang">
                <label>کد زبان جدید (مثال: es, fr, ar):</label>
                <input type="text" name="new_lang_code" placeholder="es" required>
                
                <label>نام زبان (مثال: Español):</label>
                <input type="text" name="new_lang_name" placeholder="Español" required>
                                <label>پرچم (مثال: 🇪🇸):</label>
                <input type="text" name="new_flag" placeholder="🇪🇸" required>
                
                <button type="submit">➕ افزودن زبان</button>
            </form>
            
            <h3>زبان‌های موجود:</h3>
            <div class="lang-list">
                <?php foreach ($langs as $lang): ?>
                    <div class="lang-item">
                        <?= $langData[$lang]['flag'] ?> <?= $langData[$lang]['name'] ?>
                        <?php if ($lang !== 'fa' && $lang !== 'en'): ?>
                            <form method="post" style="display:inline;">
                                <input type="hidden" name="action" value="delete_lang">
                                <input type="hidden" name="delete_lang" value="<?= $lang ?>">
                                <button type="submit" style="background:red; padding:2px 5px;">🗑️ حذف</button>
                            </form>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <!-- خروج -->
        <?php if (isset($_GET['logout'])) {
            session_destroy();
            header("Location: admin.php");
            exit;
        } ?>
    </div>
</body>
</html>