<?php
// ================= تنظیمات اصلی =================
$botToken = "8122895492:AAHORHk3Q_7pM9mF2VJCwGKBR3v9ZuyDPh0";
$webAppUrl = "https://gemini.google.com/app";
$tutorialUrl = "https://t.me/AiPramit";
$lockChannelId = "@AiPramit"; // کانال عضویت اجباری

// ================= دیتابیس =================
$dbFile = __DIR__."/buttons.db";
$db = new PDO("sqlite:$dbFile");
$db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// ایجاد جداول
$db->exec("
CREATE TABLE IF NOT EXISTS buttons (
    chat_id     INTEGER PRIMARY KEY,
    message_id  INTEGER,
    lang        TEXT,
    expire_at   INTEGER,
    is_waiting  INTEGER
);
CREATE INDEX IF NOT EXISTS idx_expire ON buttons(expire_at);

CREATE TABLE IF NOT EXISTS users (
    chat_id     INTEGER PRIMARY KEY,
    lang        TEXT DEFAULT 'fa',
    first_seen  INTEGER
);

CREATE TABLE IF NOT EXISTS settings (
    key         TEXT PRIMARY KEY,
    value       TEXT
);
");

// === [AI Chat Mode - New UI] === اضافه کردن ستون ai_chat_mode
try {
    $db->exec("ALTER TABLE users ADD COLUMN ai_chat_mode INTEGER DEFAULT 0");
} catch (Exception $e) {
    // نادیده گرفتن خطا اگر ستون وجود داشته باشد
}

// ================= تنظیمات پیش‌فرض =================
$defaultSettings = [
    'tutorial_text_fa' => "📚 *آموزش استفاده*\n\nبرای استفاده از ربات:\n1. روی دکمه 🤖 متصل شدن به هوش مصنوعی کلیک کنید\n2. VPN خود را روشن کنید\n3. از هوش مصنوعی گوگل استفاده کنید!",
    'tutorial_link_fa' => "https://t.me/AiPramit",
    'prompt_text_fa' => "📢 *کانال پرامپت*\n\nبه کانال ما بپیوندید تا از جدیدترین پرامپت‌ها مطلع شوید!",
    'prompt_link_fa' => "https://t.me/AiPramit",
    'support_text_fa' => "👤 *پشتیبانی*\n\nدر صورت بروز مشکل، با پشتیبانی تماس بگیرید.",
    'support_link_fa' => "https://t.me/MansourDev",    'tutorial_text_en' => "📚 *Tutorial*\n\nHow to use the bot:\n1. Click 🤖 Connect to AI\n2. Turn on your VPN\n3. Use Google AI!",
    'tutorial_link_en' => "https://t.me/AiPramit",
    'prompt_text_en' => "📢 *Prompts Channel*\n\nJoin our channel for the latest prompts!",
    'prompt_link_en' => "https://t.me/AiPramit",
    'support_text_en' => "👤 *Support*\n\nContact support if you have any issues.",
    'support_link_en' => "https://t.me/MansourDev",
];

foreach ($defaultSettings as $key => $value) {
    $stmt = $db->prepare("INSERT OR IGNORE INTO settings (key, value) VALUES (:key, :value)");
    $stmt->execute([':key' => $key, ':value' => $value]);
}

// ================= دریافت آپدیت =================
$update = json_decode(file_get_contents("php://input"), true);
if (!isset($update['message']) && !isset($update['callback_query'])) exit;

$chatId = null;
$text = "";
$callbackData = null;
$messageType = null;

if (isset($update['message'])) {
    $chatId = $update['message']['chat']['id'];
    $text = $update['message']['text'] ?? "";
    $messageType = $update['message']['chat']['type'];
    $stmt = $db->prepare("INSERT OR IGNORE INTO users (chat_id, lang, first_seen, ai_chat_mode) VALUES (:chat_id, 'fa', :time, 0)");
    $stmt->execute([':chat_id' => $chatId, ':time' => time()]);
} elseif (isset($update['callback_query'])) {
    $chatId = $update['callback_query']['from']['id'];
    $callbackData = $update['callback_query']['data'] ?? "";
    file_get_contents("https://api.telegram.org/bot$botToken/answerCallbackQuery?callback_query_id=" . $update['callback_query']['id']);
    $stmt = $db->prepare("INSERT OR IGNORE INTO users (chat_id, lang, first_seen, ai_chat_mode) VALUES (:chat_id, 'fa', :time, 0)");
    $stmt->execute([':chat_id' => $chatId, ':time' => time()]);
}

// ================= زبان‌ها =================
$langData = [
    'fa' => ['flag' => '🇮🇷', 'name' => 'فارسی', 'btn_select' => '🇮🇷 فارسی', 'menu_lang' => '🌐 تغییر زبان', 'welcome' => "👋 خوش آمدید! انتخاب کنید:", 'menu_ai' => "🤖 متصل شدن به هوش مصنوعی گوگل", 'menu_prompt' => "📢 کانال پرامپت", 'menu_tutorial' => "📚 آموزش استفاده", 'menu_support' => "👤 پشتیبانی", 'txt_ai_click' => "👇 روی دکمه ورود کلیک کنید (حذف در ۱ دقیقه):", 'txt_ai_btn' => "🚀 ورود به هوش مصنوعی", 'vpn_warn' => "\n\n⚠️ VPN روشن باشد.", 'btn_tutorial_inline' => "📹 آموزش VPN", 'lang_changed' => "✅ زبان تغییر کرد.", 'wait_msg' => "⏳ شما یک دکمه فعال دارید، لطفاً صبر کنید.", 'join_msg' => "⚠️ ابتدا عضو کانال شوید:", 'join_btn' => "عضویت", 'joined_check_btn' => "عضو شدم ✅", 'menu_ai_chat' => "💬 چت با هوش مصنوعی", 'ai_chat_welcome' => "💬 شما اکنون در بخش چت با هوش مصنوعی هستید.\nهر پیامی که ارسال کنید، به هوش مصنوعی فرستاده می‌شود.", 'back_btn' => "🔙 برگشت"],
    'en' => ['flag' => '🇺🇸', 'name' => 'English', 'btn_select' => '🇺🇸 English', 'menu_lang' => '🌐 Change Language', 'welcome' => "👋 Welcome!", 'menu_ai' => "🤖 Connect to AI", 'menu_prompt' => "📢 Prompts", 'menu_tutorial' => "📚 Tutorial", 'menu_support' => "👤 Support", 'txt_ai_click' => "👇 Click the button (expires in 1 min):", 'txt_ai_btn' => "🚀 Open AI", 'vpn_warn' => "\n\n⚠️ Turn on VPN.", 'btn_tutorial_inline' => "📹 VPN Tutorial", 'lang_changed' => "✅ Language changed.", 'wait_msg' => "⏳ You already have an active button.", 'join_msg' => "⚠️ Join the channel first:", 'join_btn' => "Join", 'joined_check_btn' => "I Joined ✅", 'menu_ai_chat' => "💬 Chat with AI", 'ai_chat_welcome' => "💬 You are now in AI chat mode.\nSend any message to talk to the AI.", 'back_btn' => "🔙 Back"],
    // سایر زبان‌ها بدون تغییر (فقط fa و en کامل شدند)
    'ru' => ['flag' => '🇷🇺', 'name' => 'Русский', 'btn_select' => '🇷🇺 Русский', 'menu_lang' => '🌐 Сменить язык', 'welcome' => "👋 Добро пожаловать!", 'menu_ai' => "🤖 Подключиться к ИИ", 'menu_prompt' => "📢 Промпты", 'menu_tutorial' => "📚 Обучение", 'menu_support' => "👤 Поддержка", 'txt_ai_click' => "👇 Нажмите кнопку (истекает через 1 мин):", 'txt_ai_btn' => "🚀 Открыть ИИ", 'vpn_warn' => "\n\n⚠️ Включите VPN.", 'btn_tutorial_inline' => "📹 Учебник по VPN", 'lang_changed' => "✅ Язык изменен.", 'wait_msg' => "⏳ У вас уже есть активная кнопка.", 'join_msg' => "⚠️ Сначала присоединитесь к каналу:", 'join_btn' => "Присоединиться", 'joined_check_btn' => "Я присоединился ✅", 'menu_ai_chat' => "💬 Чат с ИИ", 'ai_chat_welcome' => "💬 Вы в режиме чата с ИИ.\nОтправьте сообщение.", 'back_btn' => "🔙 Назад"],
    'uz' => ['flag' => '🇺🇿', 'name' => 'O\'zbekcha', 'btn_select' => '🇺🇿 O\'zbekcha', 'menu_lang' => '🌐 Tilni o\'zgartirish', 'welcome' => "👋 Xush kelibsiz!", 'menu_ai' => "🤖 Sunʼiy intellektga ulanish", 'menu_prompt' => "📢 Promptlar", 'menu_tutorial' => "📚 Oʻqituvchi", 'menu_support' => "👤 Qo'llab-quvvatlash", 'txt_ai_click' => "👇 Tugmani bosing (1 daqiqadan keyin muddati tugaydi):", 'txt_ai_btn' => "🚀 Sunʼiy intellektga kirish", 'vpn_warn' => "\n\n⚠️ VPN ni yoqing.", 'btn_tutorial_inline' => "📹 VPN darsligi", 'lang_changed' => "✅ Til o'zgartirildi.", 'wait_msg' => "⏳ Sizda allaqachon faol tugma bor.", 'join_msg' => "⚠️ Avval kanalga a'zo bo'ling:", 'join_btn' => "A'zo bo'lish", 'joined_check_btn' => "Men a'zo bo'ldim ✅", 'menu_ai_chat' => "💬 Sunʼiy intellekt bilan suhbat", 'ai_chat_welcome' => "💬 Siz sunʼiy intellekt bilan suhbat rejimidasiz.\nXabar yuboring.", 'back_btn' => "🔙 Orqaga"],
    'tr' => ['flag' => '🇹🇷', 'name' => 'Türkçe', 'btn_select' => '🇹🇷 Türkçe', 'menu_lang' => '🌐 Dili değiştir', 'welcome' => "👋 Hoş geldiniz!", 'menu_ai' => "🤖 Yapay zekâya bağlan", 'menu_prompt' => "📢 İpuçları", 'menu_tutorial' => "📚 Eğitim", 'menu_support' => "👤 Destek", 'txt_ai_click' => "👇 Butona tıkla (1 dakika sonra süresi dolacak):", 'txt_ai_btn' => "🚀 Yapay zekâya giriş", 'vpn_warn' => "\n\n⚠️ VPN'i aç.", 'btn_tutorial_inline' => "📹 VPN Eğitimi", 'lang_changed' => "✅ Dil değiştirildi.", 'wait_msg' => "⏳ Zaten aktif bir butonun var.", 'join_msg' => "⚠️ Önce kanala katıl:", 'join_btn' => "Katıl", 'joined_check_btn' => "Katıldım ✅", 'menu_ai_chat' => "💬 Yapay zekâ ile sohbet", 'ai_chat_welcome' => "💬 Yapay zekâ sohbet modundasınız.\nMesaj gönderin.", 'back_btn' => "🔙 Geri"],
    'es' => ['flag' => '🇪🇸', 'name' => 'Español', 'btn_select' => '🇪🇸 Español', 'menu_lang' => '🌐 Cambiar idioma', 'welcome' => "👋 ¡Bienvenido!", 'menu_ai' => "🤖 Conectarse a IA", 'menu_prompt' => "📢 Prompts", 'menu_tutorial' => "📚 Tutoriales", 'menu_support' => "👤 Soporte", 'txt_ai_click' => "👇 Haz clic en el botón (caduca en 1 min):", 'txt_ai_btn' => "🚀 Abrir IA", 'vpn_warn' => "\n\n⚠️ Enciende la VPN.", 'btn_tutorial_inline' => "📹 Tutoriales de VPN", 'lang_changed' => "✅ Idioma cambiado.", 'wait_msg' => "⏳ Ya tienes un botón activo.", 'join_msg' => "⚠️ Primero únete al canal:", 'join_btn' => "Unirse", 'joined_check_btn' => "Me uní ✅", 'menu_ai_chat' => "💬 Chatear con IA", 'ai_chat_welcome' => "💬 Estás en modo de chat con IA.\nEnvía un mensaje.", 'back_btn' => "🔙 Volver"],
    'fr' => ['flag' => '🇫🇷', 'name' => 'Français', 'btn_select' => '🇫🇷 Français', 'menu_lang' => '🌐 Changer de langue', 'welcome' => "👋 Bienvenue !", 'menu_ai' => "🤖 Se connecter à l'IA", 'menu_prompt' => "📢 Prompts", 'menu_tutorial' => "📚 Tutoriel", 'menu_support' => "👤 Support", 'txt_ai_click' => "👇 Cliquez sur le bouton (expire dans 1 min):", 'txt_ai_btn' => "🚀 Ouvrir l'IA", 'vpn_warn' => "\n\n⚠️ Activez le VPN.", 'btn_tutorial_inline' => "📹 Tutoriel VPN", 'lang_changed' => "✅ Langue changée.", 'wait_msg' => "⏳ Vous avez déjà un bouton actif.", 'join_msg' => "⚠️ Rejoignez d'abord le canal :", 'join_btn' => "Rejoindre", 'joined_check_btn' => "J'ai rejoint ✅", 'menu_ai_chat' => "💬 Discuter avec l'IA", 'ai_chat_welcome' => "💬 Vous êtes en mode discussion avec l'IA.\nEnvoyez un message.", 'back_btn' => "🔙 Retour"],
    'ar' => ['flag' => '🇸🇦', 'name' => 'العربية', 'btn_select' => '🇸🇦 العربية', 'menu_lang' => '🌐 تغيير اللغة', 'welcome' => "👋 أهلاً بك!", 'menu_ai' => "🤖 الاتصال بالذكاء الاصطناعي", 'menu_prompt' => "📢 النصوص التوجيهية", 'menu_tutorial' => "📚 التعليمات", 'menu_support' => "👤 الدعم", 'txt_ai_click' => "👇 اضغط على الزر (ينتهي بعد دقيقة واحدة):", 'txt_ai_btn' => "🚀 الدخول للذكاء الاصطناعي", 'vpn_warn' => "\n\n⚠️ شغل الـ VPN.", 'btn_tutorial_inline' => "📹 تعليمات الـ VPN", 'lang_changed' => "✅ تم تغيير اللغة.", 'wait_msg' => "⏳ لديك زر نشط بالفعل، يرجى الانتظار.", 'join_msg' => "⚠️ انضم إلى القناة أولًا:", 'join_btn' => "الانضمام", 'joined_check_btn' => "لقد انضممت ✅", 'menu_ai_chat' => "💬 الدردشة مع الذكاء الاصطناعي", 'ai_chat_welcome' => "💬 أنت الآن في وضع الدردشة مع الذكاء الاصطناعي.\nأرسل أي رسالة.", 'back_btn' => "🔙 رجوع"]
];
// ================= توابع =================
function sendMessage($chatId, $text, $markup = null) {    global $botToken;
    $url = "https://api.telegram.org/bot$botToken/sendMessage";
    $data = ['chat_id' => $chatId, 'text' => $text, 'parse_mode' => 'Markdown'];
    if ($markup) $data['reply_markup'] = $markup;
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $res = curl_exec($ch);
    curl_close($ch);
    return $res;
}

function isJoinedChannel($chatId, $channel) {
    global $botToken;
    $res = file_get_contents("https://api.telegram.org/bot$botToken/getChatMember?" . http_build_query([
        'chat_id' => $channel,
        'user_id' => $chatId
    ]));
    $data = json_decode($res, true);
    if ($data['ok']) {
        $status = $data['result']['status'];
        return in_array($status, ['member', 'administrator', 'creator']);
    }
    return false;
}

// === [AI Chat Mode - New UI] === ارسال به هوش مصنوعی
function sendToAI($chatId, $text, $userId) {
    global $botToken, $langData;
    
    // بارگذاری زبان کاربر از دیتابیس
    $dbFile = __DIR__."/buttons.db";
    $db = new PDO("sqlite:$dbFile");
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $stmt = $db->prepare("SELECT lang FROM users WHERE chat_id = :chat_id");
    $stmt->execute([':chat_id' => $chatId]);
    $userLang = $stmt->fetchColumn() ?: 'fa';
    $L = $langData[$userLang];

    $ttext = urlencode($text);
    $url = "https://api2.haji-api.ir/rr/index.php?text=$ttext&user_id=$userId";
    
    file_get_contents("https://api.telegram.org/bot$botToken/sendChatAction?chat_id=$chatId&action=typing");
    
    $response = file_get_contents($url);
    $data = json_decode($response, true);
    
    if (isset($data['answer'])) {
        $ikb = json_encode(["inline_keyboard" => [[["text" => $L['back_btn'], "callback_data" => "ai_chat_back"]]]]);
        $sendUrl = "https://api.telegram.org/bot$botToken/sendMessage?" . http_build_query([            'chat_id' => $chatId,
            'text' => $data['answer'],
            'parse_mode' => 'Markdown',
            'reply_markup' => $ikb
        ]);
        file_get_contents($sendUrl);
    } else {
        sendMessage($chatId, "❌ خطایی در دریافت پاسخ رخ داد.");
    }
}
// ================= بارگذاری زبان کاربر =================
$stmt = $db->prepare("SELECT lang FROM buttons WHERE chat_id=:chat_id");
$stmt->execute([':chat_id' => $chatId]);
$row = $stmt->fetch(PDO::FETCH_ASSOC);
$userLang = $row['lang'] ?? 'fa';
$L = $langData[$userLang];

// ================= پردازش کالبک‌ها =================
if ($callbackData) {
    // --- عضویت اجباری ---
    if ($callbackData === 'check_join') {
        if (!isJoinedChannel($chatId, $lockChannelId)) {
            $ikb = json_encode(["inline_keyboard" => [[["text" => $L['join_btn'], "url" => "https://t.me/AiPramit"]], [["text" => $L['joined_check_btn'], "callback_data" => "check_join"]]]]);
            sendMessage($chatId, $L['join_msg'], $ikb);
        }
        exit;
    }

    // === [AI Chat Mode - New UI] === برگشت از چت
    if ($callbackData === 'ai_chat_back') {
        // غیرفعال کردن حالت چت
        $stmt = $db->prepare("UPDATE users SET ai_chat_mode = 0 WHERE chat_id = :chat_id");
        $stmt->execute([':chat_id' => $chatId]);

        // ارسال منوی اصلی
        $keyboard = [
            [["text" => $L['menu_ai']]],
            [["text" => $L['menu_ai_chat']]], // ← این خط جابجا شده
            [["text" => $L['menu_prompt']], ["text" => $L['menu_tutorial']]],
            [["text" => $L['menu_support']], ["text" => $L['menu_lang']]]
        ];
        sendMessage($chatId, $L['welcome'], json_encode(["keyboard" => $keyboard, "resize_keyboard" => true]));
        exit;
    }

    if (strpos($callbackData, 'setlang_') === 0) {
        $newLang = substr($callbackData, 8);
        if (isset($langData[$newLang])) {
            $userLang = $newLang;
            $L = $langData[$newLang];            $stmt = $db->prepare("UPDATE buttons SET lang=:lang WHERE chat_id=:chat_id");
            $stmt->execute([':lang' => $userLang, ':chat_id' => $chatId]);
            $stmt = $db->prepare("UPDATE users SET lang=:lang WHERE chat_id=:chat_id");
            $stmt->execute([':lang' => $userLang, ':chat_id' => $chatId]);
            sendMessage($chatId, $L['lang_changed']);
            $keyboard = [
                [["text" => $L['menu_ai']]],
                [["text" => $L['menu_ai_chat']]], // ← این خط جابجا شده
                [["text" => $L['menu_prompt']], ["text" => $L['menu_tutorial']]],
                [["text" => $L['menu_support']], ["text" => $L['menu_lang']]]
            ];
            sendMessage($chatId, $L['welcome'], json_encode(["keyboard" => $keyboard, "resize_keyboard" => true]));
        }
        exit;
    }
}

// === [AI Chat Mode - New UI] === پردازش پیام در حالت چت (فقط private)
if (isset($update['message']) && $messageType === 'private' && $text !== '' && !in_array($text, ['/start', '/menu'])) {
    $stmt = $db->prepare("SELECT ai_chat_mode FROM users WHERE chat_id = :chat_id");
    $stmt->execute([':chat_id' => $chatId]);
    $userRow = $stmt->fetch(PDO::FETCH_ASSOC);
    $aiChatMode = (int)($userRow['ai_chat_mode'] ?? 0);

    if ($aiChatMode === 1) {
        sendToAI($chatId, $text, $chatId);
        exit;
    }
}

// ================= منوی اصلی =================
if ($text == "/start" || $text == "/menu") {
    $stmt = $db->prepare("UPDATE users SET ai_chat_mode = 0 WHERE chat_id = :chat_id");
    $stmt->execute([':chat_id' => $chatId]);

    $stmt = $db->prepare("UPDATE users SET lang=:lang WHERE chat_id=:chat_id");
    $stmt->execute([':lang' => $userLang, ':chat_id' => $chatId]);

    $keyboard = [
        [["text" => $L['menu_ai']]],
        [["text" => $L['menu_ai_chat']]], // ← این خط جابجا شده
        [["text" => $L['menu_prompt']], ["text" => $L['menu_tutorial']]],
        [["text" => $L['menu_support']], ["text" => $L['menu_lang']]]
    ];
    sendMessage($chatId, $L['welcome'], json_encode(["keyboard" => $keyboard, "resize_keyboard" => true]));
    exit;
}

// ... (بقیه منوها بدون تغییر: تغییر زبان، آموزش، پرامپت، پشتیبانی)
// ================= دکمه آموزش =================
if ($text == $L['menu_tutorial']) {
    $stmt = $db->prepare("SELECT value FROM settings WHERE key = :key");
    $stmt->execute([':key' => 'tutorial_text_' . $userLang]);
    $msgText = $stmt->fetchColumn() ?: "محتوای آموزش تنظیم نشده است.";
    $stmt = $db->prepare("SELECT value FROM settings WHERE key = :key");
    $stmt->execute([':key' => 'tutorial_link_' . $userLang]);
    $link = $stmt->fetchColumn() ?: "https://t.me/AiPramit";
    $ikb = json_encode(["inline_keyboard" => [[["text" => "🔗 لینک آموزش", "url" => $link]]]]);
    sendMessage($chatId, $msgText, $ikb);
    exit;
}
// ================= دکمه کانال پرامپت =================
if ($text == $L['menu_prompt']) {
    $stmt = $db->prepare("SELECT value FROM settings WHERE key = :key");
    $stmt->execute([':key' => 'prompt_text_' . $userLang]);
    $msgText = $stmt->fetchColumn() ?: "محتوای کانال پرامپت تنظیم نشده است.";
    $stmt = $db->prepare("SELECT value FROM settings WHERE key = :key");
    $stmt->execute([':key' => 'prompt_link_' . $userLang]);
    $link = $stmt->fetchColumn() ?: "https://t.me/AiPramit";
    $ikb = json_encode(["inline_keyboard" => [[["text" => "📢 عضویت در کانال", "url" => $link]]]]);
    sendMessage($chatId, $msgText, $ikb);
    exit;
}
// ================= دکمه پشتیبانی =================
if ($text == $L['menu_support']) {
    $stmt = $db->prepare("SELECT value FROM settings WHERE key = :key");
    $stmt->execute([':key' => 'support_text_' . $userLang]);
    $msgText = $stmt->fetchColumn() ?: "محتوای پشتیبانی تنظیم نشده است.";
    $stmt = $db->prepare("SELECT value FROM settings WHERE key = :key");
    $stmt->execute([':key' => 'support_link_' . $userLang]);
    $link = $stmt->fetchColumn() ?: "https://t.me/MansourDev";
    $ikb = json_encode(["inline_keyboard" => [[["text" => "👤 تماس با پشتیبانی", "url" => $link]]]]);
    sendMessage($chatId, $msgText, $ikb);
    exit;
}

// === [AI Chat Mode - New UI] === ورود به بخش چت
if ($text == $L['menu_ai_chat']) {
    // فعال کردن حالت چت
    $stmt = $db->prepare("UPDATE users SET ai_chat_mode = 1 WHERE chat_id = :chat_id");
    $stmt->execute([':chat_id' => $chatId]);

    // ارسال صفحه چت با دکمه برگشت (inline)
    $ikb = json_encode(["inline_keyboard" => [[["text" => $L['back_btn'], "callback_data" => "ai_chat_back"]]]]);
    sendMessage($chatId, $L['ai_chat_welcome'], $ikb);
    exit;
}

// ================= دکمه AI (بدون تغییر) =================if ($text == $L['menu_ai']) {
    if (!isJoinedChannel($chatId, $lockChannelId)) {
        $ikb = json_encode(["inline_keyboard" => [[["text" => $L['join_btn'], "url" => "https://t.me/AiPramit"]], [["text" => $L['joined_check_btn'], "callback_data" => "check_join"]]]]);
        sendMessage($chatId, $L['join_msg'], $ikb);
        exit;
    }

    $now = time();
    $db->exec("UPDATE buttons SET is_waiting=0 WHERE expire_at<=$now");
    $stmt = $db->prepare("SELECT is_waiting FROM buttons WHERE chat_id=:chat_id");
    $stmt->execute([':chat_id' => $chatId]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!empty($row['is_waiting'])) {
        sendMessage($chatId, $L['wait_msg']);
        exit;
    }

    $ikb = json_encode([
        "inline_keyboard" => [
            [["text" => $L['txt_ai_btn'], "web_app" => ["url" => $webAppUrl]]],
            [["text" => $L['btn_tutorial_inline'], "url" => $tutorialUrl]]
        ]
    ]);
    $res = sendMessage($chatId, $L['txt_ai_click'] . $L['vpn_warn'], $ikb);
    $resArr = json_decode($res, true);

    if (isset($resArr['result']['message_id'])) {
        $mid = $resArr['result']['message_id'];
        $expire = time() + 60;
        $stmt = $db->prepare("
            INSERT INTO buttons (chat_id, message_id, lang, expire_at, is_waiting)
            VALUES (:chat_id, :mid, :lang, :expire, 1)
            ON CONFLICT(chat_id) DO UPDATE SET
                message_id=:mid,
                lang=:lang,
                expire_at=:expire,
                is_waiting=1
        ");
        $stmt->execute([
            ':chat_id' => $chatId,
            ':mid' => $mid,
            ':lang' => $userLang,
            ':expire' => $expire
        ]);
    }
